/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class Label extends Control {
	String text = "";
	Image image;

public Label (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
	style |= SWT.NO_FOCUS;
	if ((style & SWT.SEPARATOR) != 0) {
		style = checkBits (style, SWT.VERTICAL, SWT.HORIZONTAL, 0, 0, 0, 0);
		return checkBits (style, SWT.SHADOW_OUT, SWT.SHADOW_IN, SWT.SHADOW_NONE, 0, 0, 0);
	} 
	return checkBits (style, SWT.LEFT, SWT.CENTER, SWT.RIGHT, 0, 0, 0);
}

public int getAlignment () {
	checkWidget ();
	if ((style & SWT.SEPARATOR) != 0) return 0;
	if ((style & SWT.LEFT) != 0) return SWT.LEFT;
	if ((style & SWT.CENTER) != 0) return SWT.CENTER;
	if ((style & SWT.RIGHT) != 0) return SWT.RIGHT;
	return SWT.LEFT;
}

public Image getImage () {
	checkWidget ();
	return image;
}

String getNameText () {
	return getText ();
}

public String getText () {
	checkWidget ();
	return text;
}

public void setAlignment (int alignment) {
	checkWidget ();
	if ((style & SWT.SEPARATOR) != 0) return;
	if ((alignment & (SWT.LEFT | SWT.RIGHT | SWT.CENTER)) == 0) return;
	style &= ~(SWT.LEFT | SWT.RIGHT | SWT.CENTER);
	style |= alignment & (SWT.LEFT | SWT.RIGHT | SWT.CENTER);
	_setAlignment (alignment);
}

public void setImage (Image image) {
	checkWidget ();
//TODO not throw exception
//	if (image != null && image.isDisposed()) error(SWT.ERROR_INVALID_ARGUMENT);
	if ((style & SWT.SEPARATOR) != 0) return;
	this.image = image;
	_setImage (image.imagePath);
}

public void setText (String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	if ((style & SWT.SEPARATOR) != 0) return;
	text = string;
	_setText (string);
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.Label"]){
		$wnd.dojo._hasResource["org.eclipse.swt.Label"] = true;
		$wnd.dojo.provide("org.eclipse.swt.Label");
		
		$wnd.dojo.require("dijit.form._FormWidget");
		$wnd.dojo.require("dijit._Container");
	
		$wnd.dojo.declare("org.eclipse.swt.Label", $wnd.dijit.form._FormWidget, {
			border: "",
			label: "",
			wrap: "nowrap",			
			baseClass: "swtLabel",
			templateString: 
				"<div class='${baseClass} swtControl' baseClass='${baseClass}' id='${id}'>" +
					"<div dojoAttachPoint='iconNode'></div>" +
					"<div dojoAttachPoint='focusNode'>${label}</div>" +
				"</div>",
			attributeMap: $wnd.dojo.mixin($wnd.dojo.clone($wnd.dijit.form._FormWidget.prototype.attributeMap),
			{label:"",wrap:""}),
			setAlignment: function(alignment){
				this.domNode.align = alignment;
			},
			setLabel: function(content){
				this.domNode.innerHTML = this.label = content;
			},
			postCreate: function(){
				this.inherited("postCreate",arguments); 
				$wnd.swt.setCssStyle(this.domNode, {
					border: this.border, 
					whiteSpace: this.wrap
				});
			},
			resize: function(dim){},
			setImage: function(image){
				this.iconNode.innerHTML = "<img src='"+image+"'/>";
			}
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	params = {};
	if((style & (@org.eclipse.swt.SWT::BORDER)) != 0){
		params.border = "1px solid black";
	}
	if((style & (@org.eclipse.swt.SWT::WRAP)) != 0){
		params.wrap = "";
	}
	var self = new $wnd.org.eclipse.swt.Label(params);        	
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native void _setAlignment (int alignment) /*-{
	if((alignment & (@org.eclipse.swt.SWT::LEFT)) != 0) {
		this.@org.eclipse.swt.widgets.Widget::jsObject.setAlignment("left");
	}
	else if((alignment & (@org.eclipse.swt.SWT::RIGHT)) != 0) {
		this.@org.eclipse.swt.widgets.Widget::jsObject.setAlignment("right");
	}
	else if((alignment & (@org.eclipse.swt.SWT::CENTER)) != 0) {
		this.@org.eclipse.swt.widgets.Widget::jsObject.setAlignment("center");
	}
}-*/;

native void _setImage (String image) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.setImage(image);	
}-*/;

native void _setText (String string) /*-{	
	this.@org.eclipse.swt.widgets.Widget::jsObject.setLabel(string);
}-*/;

}
